/*
* --------------------------------------------------------------------
* Copyright c                  Realtek Semiconductor Corporation, 2003  
* All rights reserved.
* 
* Program : 8651B crypto engine driver code
* Abstract : 
* $Id: rtl865xc_cryptoEngine.c,v 1.8 2006/03/17 08:55:36 yjlou Exp $
*
* --------------------------------------------------------------------
*/

//#include <common.h>
#include "rtl865xc_cryptoEngine.h"
#include "crypto.h"
//#ifdef CONFIG_RTL865X_MODEL_KERNEL
//#include "modelTrace.h"
//#include "icExport.h"
//#include "virtualMac.h"
//#endif
//#include <linux/autoconf.h>
//#include <asicRegs.h>
//#include "8672_asicregs.h"
//#include <rtl_glue.h>
//#include <rtl_utils.h>
//#include <assert.h>
#include "rtl865xc_asicregs.h"
#include <linux/module.h>
#include <linux/moduleloader.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/slab.h>
#include <linux/vmalloc.h>
#include <linux/elf.h>
#include <linux/seq_file.h>
#include <linux/syscalls.h>
#include <linux/string.h>

/*
#define rtlglue_malloc malloc
#define rtlglue_free free
#define rtlglue_printf printf
*/
/*  Crypto engine debug level
 */
#define _CRYPTO_DEBUG_ 1


/*  Data Segment for IC Verification
 *    In the normal mode (also compatible mode), 'DATA_SEG' is set to 1.
 *    When we want to test the multiple data segment mode, we shall set 'DATA_SEG' more than 1.
 */
#define DATA_SEG 1


uint32 numSrc, numDst; /* the number of source & destination descriptor */
uint32 idxCpuSrc, idxAsicSrc;
uint32 idxCpuDst, idxAsicDst;

/*
Assumption:
1. rtlglue_malloc() can get 4-byte aligned memory block
*/
rtl865xc_crypto_source_t *ipssdar;
rtl865xc_crypto_dest_t *ipsddar;
/*Counters for interrupt*/
static uint32 cryptoDoneIntCounter, cryptoAllDoneIntCounter;



int32 rtl8651b_cryptoEngine_alloc(uint32 descNum) 
{
	void *p; /* for memory allocate */

	/* Allocate descriptor ring */
	if ( ipssdar == NULL )
	{
		numSrc = descNum;
		p = kmalloc( numSrc * sizeof( rtl865xc_crypto_source_t ), GFP_ATOMIC );
		if ( p == NULL ) 
		{ 
			rtlglue_printf("%s():%d memory allocate failed.\n", __FUNCTION__, __LINE__ ); 
			numSrc = -1;
			return FAILED; 
		}
		ipssdar = UNCACHED_ADDRESS(p);
		memset( ipssdar, 0, numSrc * sizeof( rtl865xc_crypto_source_t ) );
		WRITE_MEM32( IPSSDAR, PHYSICAL_ADDRESS((uint32)ipssdar) );
		#if _CRYPTO_DEBUG_>=2
		rtlglue_printf( "Set IPSSDAR=0x%08x, ipssdar = 0x%08x\n", PHYSICAL_ADDRESS((uint32)ipssdar) , ipssdar);
		#endif
		ipssdar[numSrc-1].eor = 1;
	}
	else
	{
		WRITE_MEM32( IPSSDAR, PHYSICAL_ADDRESS((uint32)ipssdar) );
	}

	/* Allocate descriptor ring */
	if ( ipsddar == NULL )
	{
		numDst = descNum;

		p = kmalloc( numDst * sizeof( rtl865xc_crypto_dest_t ),GFP_ATOMIC );
		if ( p == NULL ) 
		{ 
			rtlglue_printf("%s():%d memory allocate failed.\n", __FUNCTION__, __LINE__ );
			numDst = -1;
			return FAILED; 
		}
		ipsddar = UNCACHED_ADDRESS(p);
		memset( ipsddar, 0, numDst * sizeof( rtl865xc_crypto_dest_t ) );
		WRITE_MEM32( IPSDDAR, PHYSICAL_ADDRESS((uint32)ipsddar) );
		#if _CRYPTO_DEBUG_>=2
		rtlglue_printf( "Set IPSDDAR=0x%08x\n", PHYSICAL_ADDRESS((uint32)ipsddar) );
		#endif
		ipsddar[numDst-1].eor = 1;
	}
	else
	{
		WRITE_MEM32( IPSDDAR, PHYSICAL_ADDRESS((uint32)ipsddar) );
	}

	return SUCCESS;
}

static uint32 _descNum;
static int8 _mode32Bytes;
/*
 *  descNum -- number of descriptor to be allocated.
 *  mode32Bytes -- 0: 16word
 *                 1: 32word
 *                 2: 64word
 */
int32 rtl8651b_cryptoEngine_init(uint32 descNum, int8 mode32Bytes) 
{
	uint32 burstSize;

	_descNum = descNum;
	_mode32Bytes = mode32Bytes;
	
	/* mode32Bytes==0 or 1 is backward-compatible */
	if ( mode32Bytes==0 ) burstSize = IPS_DMBS_16|IPS_SMBS_16;
	else if ( mode32Bytes==1 ) burstSize = IPS_DMBS_32|IPS_SMBS_32;
	else if ( mode32Bytes==2 ) burstSize = IPS_DMBS_64|IPS_SMBS_64;
	else return FAILED;

	if ( descNum == 0 ) return FAILED;
	if ( descNum < (2+DATA_SEG) ) return FAILED; /* key+iv+dataSegs */
	
	/* Software Reset */
	WRITE_MEM32( IPSCSR, READ_MEM32(IPSCSR)|IPS_SRST );

	rtl8651b_cryptoEngine_alloc( descNum );
	
	idxCpuSrc = idxAsicSrc = 0;
	idxCpuDst = idxAsicDst = 0;

	/* We must delay a while after software reset. */
	WRITE_MEM32( IPSCTR, 0/*IPS_LBKM*/|IPS_SAWB|IPS_CKE|burstSize );
	WRITE_MEM32( IPSCSR, READ_MEM32(IPSCSR)|IPS_SDUEIP|IPS_SDLEIP|IPS_DDUEIP|IPS_DDOKIP ); /* write 1 to clear */

	return SUCCESS;
}


int32 rtl8651b_cryptoEngine_free( void ) 
{
	if ( ipssdar )
	{
		kfree( KSEG0_ADDRESS( ipssdar ) );
		ipssdar = NULL;
	}
	if ( ipsddar )
	{
		kfree( KSEG0_ADDRESS( ipsddar ) );
		ipsddar = NULL;
	}
	return SUCCESS;
}


int32 rtl8651b_cryptoEngine_exit( void ) 
{
	rtl8651b_cryptoEngine_free();
	
	return SUCCESS;
}


int32 rtl8651b_cryptoMemcpy(void *dest)
{
	return FAILED;
}

/*data, key and iv does not have 4-byte alignment limitatiuon
 *mode bits:
 *        0x00   0x20
 *        DES  / AES
 * 0x01:  3DES   none
 * 0x02:  ECB    ECB
 * 0x04:  Enc    Enc
 * 0x08:  nBlk   nBlk
 * 0x10:  DMA    DMA
 *
 * CBC_AES:0x20
 * ECB_AES:0x22
 * CTR_AES:0x23
*/
int32 rtl8651b_cryptoEngine_des(uint32 mode, int8 *data, uint32 len, int8 *key, int8 *iv ) 
{
	static rtl865xc_crypto_source_t prepSrc[2+DATA_SEG]; /* MS=00: KeyArray+IvArray+DataSegs */
	static rtl865xc_crypto_dest_t prepDst[1];
	uint32 prepNum = 0; /* the number of descriptor prepare to write ASIC */
	int i;

	memset( prepSrc, 0, sizeof(prepSrc) );
	memset( prepDst, 0, sizeof(prepDst) );
	

    if ( mode & 0x20 )
	{ /* AES */
		if( len == 0 ||
		    len > 16368 ||
		    len & 0xf)
		{
			#if _CRYPTO_DEBUG_>=1
			rtlglue_printf("%s():%d\n", __FUNCTION__, __LINE__ );	
			#endif
			return FAILED;/*Unable to process non-16-byte aligned data*/
		}
		
		/* AES */
		prepSrc[0].own = 1; /* Own by crypto */
		prepSrc[0].ms = 0; /* Mode Select = AES/DES/3DES */
		prepSrc[0].aeskl = 1; /* AES Key Length = 128 bits */
		switch ( mode & 0x03 )
		{
			case 0x00: /* CBC mode */
				prepSrc[0].cbc = 1;
				break;
			case 0x02: /* ECB mode */
				prepSrc[0].cbc = 0;
				break;
			case 0x03: /* Counter mode */
				prepSrc[0].ctr = 1;
				break;
			default:
				#if _CRYPTO_DEBUG_>=1
				rtlglue_printf("%s():%d\n", __FUNCTION__, __LINE__ );	
				#endif
				return FAILED;
				break;
		}
		if ( mode & 0x04 )
		{
			prepSrc[0].kam = 7; /* Key Application Mechanism: Encryption */
		}
		else
		{
			prepSrc[0].kam = 0; /* Key Application Mechanism: Decryption */
		}

		/* first descriptor: Key Array */
		prepSrc[0].fs = 1;
		prepSrc[0].sbl = 128/8; /* Key Array Length */
		prepSrc[0].a2eo = 0;
		prepSrc[0].enl = len;
		prepSrc[0].apl = 0;
		prepSrc[0].sdbp = PHYSICAL_ADDRESS( key );
		
		/* second descriptor: IV Array */
		prepSrc[1].own = 1; /* Own by crypto */
		prepSrc[1].fs = 0;
		prepSrc[1].sbl = 128/8; /* IV Array Length */
		prepSrc[1].a2eo = 0;
		prepSrc[1].enl = len;
		prepSrc[1].apl = 0;
		prepSrc[1].sdbp = PHYSICAL_ADDRESS( iv );
		
		/* third descriptor and so on: Data */
		for( i = 0; i < DATA_SEG; i++ )
		{
			prepSrc[2+i].own = 1; /* Own by crypto */
			prepSrc[2+i].fs = 0;
			if ( i==(DATA_SEG-1) )
				prepSrc[2+i].sbl = len-(len/DATA_SEG)*(DATA_SEG-1); /* Data Length */
			else
				prepSrc[2+i].sbl = len/DATA_SEG; /* Data Length */
			prepSrc[2+i].a2eo = 0;
			prepSrc[2+i].enl = len;
			prepSrc[2+i].apl = 0;
			prepSrc[2+i].sdbp = PHYSICAL_ADDRESS( data+(len/DATA_SEG)*i );
		}

		prepNum = 2+DATA_SEG;
	}
	else
	{ /* DES/3DES */
		if( len == 0 ||
		    len > 16376 ||
		    len & 0x7)
		{
			#if _CRYPTO_DEBUG_>=1
			rtlglue_printf("%s():%d\n", __FUNCTION__, __LINE__ );	
			#endif
			return FAILED;/*Unable to process non-8-byte aligned data*/
		}

 //       printk("%s():%d . len is %d\n", __FUNCTION__, __LINE__ , len); 
		/* DES/3DES */
		prepSrc[0].own = 1; /* Own by crypto */
		prepSrc[0].ms = 0; /* Mode Select = AES/DES/3DES */
		prepSrc[0].aeskl = 0; /* DES/3DES */
		if ( mode & 1 )
		{
			/* 3DES */
			prepSrc[0].trides = 1;
			prepSrc[0].sbl = 24; /* Key Array Length */
			if ( mode & 4 )
				prepSrc[0].kam = 5; /* Encryption */
			else
			{
			//	static uint8 _swapped[24];
			//	uint8* swapped = UNCACHED_ADDRESS( _swapped );
			//	uint8* pk = key; /* for compiler */

				prepSrc[0].kam = 2; /* Decryption */
				/* for descryption, we need to swap K1 and K3 (K1,K2,K3)==>(K3,K2,K1). */
			//	memcpy( &swapped[16], &pk[0], 8 );
			//	memcpy( &swapped[8], &pk[8], 8 );
			//	memcpy( &swapped[0], &pk[16], 8 );
			//	key = swapped; /* re-pointer to new key */
   //         printk("%s():%d .\n", __FUNCTION__, __LINE__ ); 
			}
		}
		else
		{
			/* DES */
			prepSrc[0].trides = 0;
			prepSrc[0].sbl = 8; /* Key Array Length */
			if ( mode & 4 )
				prepSrc[0].kam = 7; /* Encryption */
			else
				prepSrc[0].kam = 0; /* Decryption */
		}
		if ( mode & 2 )
			prepSrc[0].cbc = 0; /* ECB */
		else
			prepSrc[0].cbc = 1; /* CBC */
			
		/* first descriptor: Key Array */
		prepSrc[0].fs = 1;
		prepSrc[0].a2eo = 0;
		prepSrc[0].enl = len;
		prepSrc[0].apl = 0;
//		prepSrc[0].sdbp = PHYSICAL_ADDRESS( key );
  //      printk("%s():%d .\n", __FUNCTION__, __LINE__ ); 
		
		/* second descriptor: IV Array */
		prepSrc[1].own = 1;
		prepSrc[1].fs = 0;
		prepSrc[1].sbl = 8; /* IV Array Length */
		prepSrc[1].a2eo = 0;
		prepSrc[1].enl = len;
		prepSrc[1].apl = 0;
//		prepSrc[1].sdbp = PHYSICAL_ADDRESS( iv );
		
		/* third descriptor and so on: Data */
		for( i = 0; i < DATA_SEG; i++ )
		{
			prepSrc[2+i].own = 1;
			prepSrc[2+i].fs = 0;
			if ( i==(DATA_SEG-1) )
				prepSrc[2+i].sbl = len-(len/DATA_SEG)*(DATA_SEG-1); /* Data Length */
			else
				prepSrc[2+i].sbl = len/DATA_SEG; /* Data Length */
			prepSrc[2+i].a2eo = 0;
			prepSrc[2+i].enl = len;
			prepSrc[2+i].apl = 0;
			prepSrc[2+i].sdbp = PHYSICAL_ADDRESS( data+(len/DATA_SEG)*i );
		}

		prepNum = 2+DATA_SEG;
	}

//printk("%s():%d .\n", __FUNCTION__, __LINE__ ); 
	/* We assume the CPU and ASIC are pointed to the same descriptor.
	 * However, in async mode, this assumption is invalid.
	 */
	if ( mode & 0x08 )
	{
		/* non-blocking mode, we cannot expect where ASIC is pointing to. */
	}
	else
	{
		/* blocking mode */
		idxAsicSrc = ((rtl865xc_crypto_source_t*)KSEG1_ADDRESS(READ_MEM32( IPSSDAR )))-ipssdar;
//		assert( idxAsicSrc == idxCpuSrc );
		idxAsicDst = ((rtl865xc_crypto_dest_t*)KSEG1_ADDRESS(READ_MEM32( IPSDDAR )))-ipsddar;
//		assert( idxAsicDst == idxCpuDst );
	}

	/* prepare destination descriptor. */
	prepDst[0].own = 1; /* set owned by ASIC */
	prepDst[0].eor = (idxCpuDst==(numDst-1)); /* If this is the final descriptor, set EOR bit. */
	prepDst[0].dbl = len; /* destination data length */
	prepDst[0].ddbp = PHYSICAL_ADDRESS( data ); /* destination data block pointer */

	/* write prepared descriptors into ASIC */
	/* 1.destination first */
	memcpy( ((char*)&ipsddar[idxCpuDst])+4, ((char*)&prepDst[0])+4, sizeof(ipsddar[0])-4 ); /* skip first word. */
	*(uint32*)&ipsddar[idxCpuDst] = *(uint32*)&prepDst[0]; /* copy the first word. */
	idxCpuDst = (idxCpuDst+1)%numDst;
	
	/* 2.then source */
	for( i = 0; i < prepNum; i++ )
	{
		if ( ipssdar[(idxCpuSrc+i)%numSrc].own == 0 )
		{
			/* Owned by CPU, overwrite it ! */
			prepSrc[i].eor = (((idxCpuSrc+i)%numSrc)==(numSrc-1)); /* If this is the final descriptor, set EOR bit. */
			memcpy( ((char*)&ipssdar[(idxCpuSrc+i)%numSrc])+4, ((char*)&prepSrc[i])+4, sizeof(ipssdar[0])-4 ); /* skip first word. */
			*(uint32*)&ipssdar[(idxCpuSrc+i)%numSrc] = *(uint32*)&prepSrc[i]; /* copy the first word. */
		}
		else
		{
#if 0
			/* Owned by ASIC.
			 * Currently, we do not support this situation. 
			 * This means one of following:
			 *  1. numSrc < prepNum
			 *  2. async operation is fired
			 */
			#if _CRYPTO_DEBUG_>=1
			rtlglue_printf("%s():%d\n", __FUNCTION__, __LINE__ );	
			#endif
			return FAILED;
#endif
		}
	}
	idxCpuSrc = (idxCpuSrc+prepNum)%numSrc;
#if 0
	#if _CRYPTO_DEBUG_>=2
	rtlglue_printf( "numSrc=%d prepNum=%d idxCpuSrc=%d(%d) idxCpuDst=%d(%d)\n", numSrc, prepNum, idxCpuSrc, idxAsicSrc, idxCpuDst, idxAsicDst );
	#endif
	memDump( (void*)IPSSDAR, 0x10, "Crypto Engine Registers" );
	for( i = 0; i < prepNum; i++ ) memDump( &ipssdar[(idxCpuSrc+numSrc-prepNum+i)%numSrc], sizeof(prepSrc[i]), "ipssdar" );
	memDump( &ipsddar[(idxCpuDst+numDst-1)%numDst], sizeof(prepDst), "ipsddar" );
#endif
#ifdef CONFIG_RTL865X_MODEL_KERNEL
	model_setTestTarget( IC_TYPE_REAL );
	modelExportSetIcType( IC_TYPE_REAL );
	modelExportSetOutputForm( EXPORT_ICEMON );
	modelExportCryptoRegisters();
#endif

	/* Clear OK flag */
	WRITE_MEM32( IPSCSR, READ_MEM32( IPSCSR ) | (IPS_SDUEIP|IPS_SDLEIP|IPS_DDUEIP|IPS_DDOKIP|IPS_DABFIP) );

	/* kick off crypto engine */
	WRITE_MEM32( IPSCSR, READ_MEM32(IPSCSR)|IPS_POLL );

	if ( mode & 0x08 )
	{
		/* non-blocking mode */
		return SUCCESS;
	}
	else
	{
		/* blocking mode */
		while( ( READ_MEM32( IPSCSR ) & (IPS_SDUEIP|IPS_SDLEIP|IPS_DDUEIP|IPS_DDOKIP|IPS_DABFIP) ) == 0 ); /* wait until crypto engine stop */
//		assert( ipsddar[(idxCpuDst+numDst-1)%numDst].own==0 ); 

		if ( READ_MEM32( IPSCSR ) & (IPS_SDLEIP|IPS_DABFIP) )
		{
			#if _CRYPTO_DEBUG_>=1
			rtlglue_printf("%s():%d READ_MEM32(IPSCSR)=0x%08x.\n", __FUNCTION__, __LINE__, READ_MEM32( IPSCSR ) );
			#endif
			return FAILED; /* error occurs */
		}
	}

	return SUCCESS;
}


int32 rtl8651b_cryptoEngine_des_poll(int32 freq)
{
	return SUCCESS;
}


void rtl8651b_cryptoEngineGetIntCounter(uint32 * doneCounter, uint32 * allDoneCounter) {
	*doneCounter = cryptoDoneIntCounter;
	*allDoneCounter = cryptoAllDoneIntCounter;
}

void rtl8651b_cryptoEngine_initdata(void)
{
	ipssdar = NULL;
	ipsddar = NULL;
	numSrc = 0;
	numDst = 0;
	idxCpuSrc = 0;
	idxAsicSrc = 0;
	idxCpuDst = 0;
	idxAsicDst = 0;
	_descNum = 0;
	 _mode32Bytes = 0;
}

